local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local ScenarioFramework = import('/lua/ScenarioFramework.lua')
local OpStrings = import('/maps/Seraphim Outpost 4v4.v0002/seraphim outpost 4v4_strings.lua')
 
local deathTaunts = {
    {OpStrings.TAUNT1, 0},
    {OpStrings.TAUNT2, 0},
    {OpStrings.TAUNT3, 0},
    {OpStrings.TAUNT4, 0},
}

function CheckCrystals()
    if (ScenarioInfo.Options.opt_Crystal_setting == nil) then
        ScenarioInfo.Options.opt_Crystal_setting = 1;
    end
    SpawnCrystals()
end

function SpawnCrystals()
    if ScenarioInfo.Options.opt_Crystal_setting == 2 then
        ScenarioUtils.CreateArmyGroup('NEUTRAL_CIVILIAN', 'Crystals')
    end
end
 
function OnPopulate()
    ScenarioUtils.InitializeArmies()
    ScenarioFramework.SetPlayableArea('AREA_1' , false)
end
   
function OnStart(self)
    SetArmyColor('NEUTRAL_CIVILIAN',255,255,255)
    SetArmyUnitCap('NEUTRAL_CIVILIAN',2000)
    CheckCrystals()
    ForkThread(handlePlayerDeaths)
    -- ForkThread(playTimedTaunt)
end

function playTimedTaunt()
    WaitSeconds(30)
    ScenarioFramework.Dialogue(OpStrings.X03_M01_064, nil, true)
end
 
function handlePlayerDeaths()
    local survivors = getAlivePlayerNumber()
   
    while(survivors > 1) do
        local curSurvivors = getAlivePlayerNumber()
        if curSurvivors < survivors then
            playRandomDeathTaunt()
            survivors = curSurvivors
        end
        WaitSeconds(1)
    end
end
 
function getAlivePlayerNumber()
    local survivors = 0
    for army, brain in ArmyBrains do
        if not ArmyIsOutOfGame(army) then
            survivors = survivors + 1
        end
    end
    return survivors
end
 
function playRandomDeathTaunt()
    local minPlayed = deathTaunts[1][2]
    for _, taunt in deathTaunts do
        if (taunt[2] < minPlayed) then
            minPlayed = taunt[2]
        end
    end
   
    while (true) do
        tauntToTest = deathTaunts[math.random(1, table.getn(deathTaunts))]
        if(tauntToTest[2] == minPlayed) then
            tauntToTest[2] = tauntToTest[2] + 1
            ScenarioFramework.Dialogue(tauntToTest[1], nil, true)
            break
        end
    end
end